﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ServiceCheck.aspx.cs" Inherits="TBI_Instruments_ServiceCheck" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Service Check</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

<script type="text/javascript" language="JavaScript" for="window" event="onLoad()">
    StartServiceCheck(); // Add something here
</script>

<script type="text/javascript" language="javascript">

    function StartServiceCheck() {
        //Give the UI thread time to draw the screen, then actually startup Sentillion.
        setTimeout(GetNextStatusLine, 100);
    }

    function GetNextStatusLine() {
        //AddToDisplay("DEBUG(ETM) - 1");
        //alert("DEBUG(ETM)");
        GetServerStatus();            
        //AddToDisplay("DEBUG(ETM) - 2");
    }

    function AddToDisplay(value) {
        var row = logTable.insertRow(logTable.rows.length);
        var cell = row.insertCell(0);
        cell.innerHTML = value;
    }

    function GetBaseLocation() {
        var loc = new String(window.location);
        var found = loc.indexOf('?', 0);
        if (found > 0)
            loc = loc.substring(0, found - 1);
        found = loc.indexOf('#');
        if (found > 0)
            loc = loc.substring(0, found - 1);
        return loc;
    }

    function GetServerStatus() {
        try {
            var loc = GetBaseLocation();
            var req = new XMLHttpRequest();
            req.open("POST", loc, true);
            req.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
            req.onreadystatechange = function ()
            {
                if (req.readyState == 4 && req.status == 200) 
                {
                    var s = req.responseText.trim();
                    if (s == "Complete") {
                        AddToDisplay("Close tab or click Reload/Refresh to re-run the test.");
                        return;
                    }
                    AddToDisplay(s);
                    GetServerStatus();
                }
            };
            req.send("GetStatus");
            // req.onreadystatechange
        }
        catch (x) {
            //if it doesn't make it to the log there's not much we can do - already displaying error to user
        }
    }

</script>

</head>

<body>
    <div>
        <table id="logTable" style="max-width: 800px; margin-left: auto; margin-right: auto; margin-top: auto; margin-bottom: auto;text-align:center;">
            <tr>
                <td>
                    <h2 style="text-align: center;">Testing VistALink Interface</h2>
                </td>
            </tr>
            <tr>
                <td>
                    <h3 style="text-align: center;">Status</h3>
                </td>
            </tr>
        </table>
    </div>

</body>
</html>
